//
//  GHRequestDataTypes.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 1/10/19.
//  Copyright © 2019 Garmin International. All rights reserved.
//

/**
 *  Enum of fetch request types.
 */
typedef NS_OPTIONS(NSInteger, GHRequestDataTypes) {
    /**
     * Wellness data
     */
    GHRequestDataWellness = 1 << 0,
    /**
     * Motion data
     */
    GHRequestDataMotion = 1 << 1,
    /**
     * Battery data
     */
    GHRequestDataBattery = 1 << 2,
    /**
     * Activity data
     */
    GHRequestDataActivity = 1 << 3,
    /**
     * MoveIQ data
     */
    GHRequestDataMoveIQ = 1 << 4,
    /**
     * Stress data
     */
    GHRequestDataStress = 1 << 5,
    /**
     * Resting heart rate data
     */
    GHRequestDataRestingHeartRate = 1 << 6,
    /**
     * VO2 data
     */
    GHRequestDataVO2 = 1 << 7,
    /**
     * SPO2 data
     */
    GHRequestDataSPO2 = 1 << 8,
    /**
     * Respiration data
     */
    GHRequestDataRespiration = 1 << 9,
    /**
     * Raw file data
     */
    GHRequestDataWellnessFiles = 1 << 10,
    /**
     * Accelerometer data
     */
    GHRequestDataAccelerometer = 1 << 11,
    /**
     * Body battery data
     */
    GHRequestDataBodyBattery = 1 << 12,
    /**
     * Logged BBI data
     */
    GHRequestDataLoggedBBI = 1 << 13,
    /**
     * Logged Zero Crossing data
     */
    GHRequestDataLoggedZeroCrossing = 1 << 14,
    /**
     * Logged Heart Rate data
     */
    GHRequestDataLoggedHeartRate = 1 << 15,
    /**
     * Logged Steps data
     */
    GHRequestDataLoggedSteps = 1 << 16,
    /**
     * Logged SPO2 data
     */
    GHRequestDataLoggedSPO2 = 1 << 17,
    /**
     * Logged Stress data
     */
    GHRequestDataLoggedStress = 1 << 18,
    /**
     * Logged Respiration data
     */
    GHRequestDataLoggedRespiration = 1 << 19,
    /**
     * Logged Accelerometer data
     */
    GHRequestDataLoggedAccelerometer = 1 << 20

};
